/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import dev.toma.gunsrpg.common.quests.condition.IQuestCondition;
import dev.toma.gunsrpg.common.quests.condition.QuestConditions;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestStatus;
import dev.toma.gunsrpg.common.quests.reward.QuestReward;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;

public final class QuestDeserializationContext<D extends IQuestData> {
    private final QuestScheme<D> scheme;
    private final UUID traderId;
    private final int rewardTier;
    private final IQuestCondition[] conditions;
    private final QuestReward reward;
    private final QuestStatus status;
    private final CompoundNBT internalData;

    public QuestDeserializationContext(QuestScheme<D> scheme, UUID traderId, int rewardTier, IQuestCondition[] conditions, QuestReward reward, QuestStatus status, CompoundNBT internalData) {
        this.scheme = scheme;
        this.traderId = traderId;
        this.rewardTier = rewardTier;
        this.conditions = conditions;
        this.reward = reward;
        this.status = status;
        this.internalData = internalData;
    }

    public static <D extends IQuestData> QuestDeserializationContext<D> fromNbt(CompoundNBT nbt) {
        QuestScheme scheme = QuestScheme.read(nbt.func_74775_l("scheme"));
        UUID createdBy = nbt.func_186857_a("createdBy");
        int rewardTier = nbt.func_74762_e("rewardTier");
        IQuestCondition[] conditions = (IQuestCondition[])nbt.func_150295_c("conditions", 10).stream().map(inbt -> QuestConditions.getConditionFromNbt((CompoundNBT)inbt)).toArray(IQuestCondition[]::new);
        QuestReward reward = null;
        if (nbt.func_74764_b("reward")) {
            CompoundNBT rewardNbt = nbt.func_74775_l("reward");
            reward = new QuestReward(rewardNbt);
        }
        QuestStatus status = QuestStatus.values()[nbt.func_74762_e("status")];
        CompoundNBT internalData = nbt.func_74775_l("internalData");
        return new QuestDeserializationContext(scheme, createdBy, rewardTier, conditions, reward, status, internalData);
    }

    public QuestScheme<D> getScheme() {
        return this.scheme;
    }

    public UUID getTraderId() {
        return this.traderId;
    }

    public int getRewardTier() {
        return this.rewardTier;
    }

    public IQuestCondition[] getConditions() {
        return this.conditions;
    }

    public QuestReward getReward() {
        return this.reward;
    }

    public QuestStatus getStatus() {
        return this.status;
    }

    public CompoundNBT getInternalData() {
        return this.internalData;
    }
}

